<!DOCTYPE html>
<html lang="pt-pt">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Listagem aluno</title>
  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../../plugins/fontawesome-free/css/all.min.css">
  <!-- Select2 -->
  <link rel="stylesheet" href="../../plugins/select2/css/select2.min.css">
  <link rel="stylesheet" href="../../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../../plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="../../plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="../../plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../../dist/css/adminlte.min.css">
  <link rel="stylesheet" href="../../style.css">
  <link rel="stylesheet" href="../../dist/bootstrap-treeview.min.css">
  <link rel="stylesheet" href="../../dist/bootstrap-treeview.min.js">
</head>
<body class="sidebar-mini iframe-mode">
<div class="wrapper">
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header" style="padding: 10px .5rem;">
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
            <div class="row">
            <div class="col-md-12">

<div class="card">
<div class="card-header">
    <div class="col-sm-6">
    <div class="form-group margem">
        <p class="card-title breadcrumb-item active">Tipo de usuário</p>
    </div>
    </div>
    <div class="card-tools">
    <button type="button" class="btn btn-tool" data-card-widget="collapse">
        <i class="fas fa-minus"></i>
    </button>
    <button type="button" class="btn btn-tool" data-card-widget="remove">
    <i class="fas fa-times"></i>
    </button>
    </div>
</div>
    <!-- /.card-header -->
    <div class="card-body">
        <div class="col-md-4">
        <div class="form-group margem">
        <input type="text" class="form-control" id="tipoUsuario" placeholder="Tipo de usuário" title="Tipo de usuário">
        </div>
        </div>
    </div>
    <!-- /.card-body -->
</div>
<!-- /.card -->
</div>
            <div class="col-md-3">
                            <div class="card">
                                <div class="card-header">
                                    <div class="col-sm-6">
                                    <div class="form-group margem">
                                        <p class="card-title breadcrumb-item active">Usuários</p>
                                    </div>
                                    </div>
                                    <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="form-group margem">
                                      <div class="input-group input-group">
                                        <input type="search" class="form-control form-control" id="codigo" name="codigo" placeholder="Pesquise" title="Pesquisar bilhete de identidade">
                                        <div class="input-group-append">
                                            <button type="button" id="btn-search" class="btn btn btn-default">
                                                <i class="fa fa-search"></i>
                                            </button>
                                        </div>
                                      </div>
                                      <small id="smallCodigo">Mensagem de erro</small>
                                    </div>
                                    <div class="form-group">
                                      <input type="text" class="form-control" id="nome" name="nome" placeholder="Aluno" title="Nome do aluno" disabled>
                                    </div>
                                    <div class="form-group">
                                      <input type="text" class="form-control" id="periodo" name="periodo" placeholder="Período" title="Período do aluno" disabled>
                                    </div>
                                    <div class="form-group">
                                      <input type="text" class="form-control" id="turma" name="turma" placeholder="Turma" title="Turma do aluno" disabled>
                                    </div>
                                    <div class="form-group">
                                      <input type="text" class="form-control" id="curso" name="curso" placeholder="Curso" title="Curso do aluno" disabled>
                                    </div>
                                    <div class="form-group">
                                        <select class="form-control select2" style="width: 100%;" id="tipoPagamento" name="tipoPagamento" title="Selecione um dos tipos de pagamentos">
                                        <option value="0">Tipo de pagamento</option>
                                        <option value="1">Não pago</option>
                                        <option value="2">Parcialmente pago</option>
                                        <option value="3">Totalmente pago</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <button type="button" name="btn-submit" id="btn-submit" class="btn btn-primary btn-block mb-3">Gravar alterações</button>
                            </div>
                <div class="col-md-9">

                <div class="card">
                    <div class="card-header">
                    <div class="col-sm-6">
                      <div class="form-group margem">
                        <p class="card-title breadcrumb-item active">Permissões:</p>
                      </div>
                    </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body p-0">
                    <div class="form-inline" style="margin-top: 20px; padding-left: 1.25rem; padding-bottom: 1.25rem">
                    <div class="input-group input-group">
                    <input type="search" class="form-control form-control" id="codigo" name="codigo" placeholder="Pesquise" title="Pesquisar bilhete de identidade">
                    <div class="input-group-append">
                        <button type="button" id="btn-search" class="btn btn btn-default">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                    </div>
                    </div>
                <table class="table table-hover">
                  <tbody id="treeView">
                    <tr>
                      <td style="padding-left: 3rem;"><i class="expandable-table-caret fas fa-caret-right fa-fw"></i><input class="custom-control-input custom-control-input-primary custom-control-input-outline" type="checkbox" id="customCheckbox5" checked><label for="customCheckbox5" class="custom-control-label" style="font-weight: 500;">183</label></td>
                    </tr>
                    <tr data-widget="expandable-table" aria-expanded="true">
                      <td>
                        <i class="expandable-table-caret fas fa-caret-right fa-fw"></i>
                        219
                      </td>
                    </tr>
                    <tr class="expandable-body">
                      <td>
                        <div class="p-0">
                          <table class="table table-hover">
                            <tbody>
                              <tr data-widget="expandable-table" aria-expanded="false">
                                <td>
                                  <i class="expandable-table-caret fas fa-caret-right fa-fw"></i>
                                  219-1
                                </td>
                              </tr>
                              <tr class="expandable-body">
                                <td>
                                  <div class="p-0">
                                    <table class="table table-hover">
                                      <tbody>
                                        <tr>
                                          <td>219-1-1</td>
                                        </tr>
                                        <tr>
                                          <td>219-1-2</td>
                                        </tr>
                                        <tr>
                                          <td>219-1-3</td>
                                        </tr>
                                      </tbody>
                                    </table>
                                  </div>
                                </td>
                              </tr>
                              <tr data-widget="expandable-table" aria-expanded="false">
                                <td>
                                  <button type="button" class="btn btn-primary p-0">
                                    <i class="expandable-table-caret fas fa-caret-right fa-fw"></i>
                                  </button>
                                  219-2
                                </td>
                              </tr>
                              <tr class="expandable-body">
                                <td>
                                  <div class="p-0">
                                    <table class="table table-hover">
                                      <tbody>
                                        <tr>
                                          <td>219-2-1</td>
                                        </tr>
                                        <tr>
                                          <td>219-2-2</td>
                                        </tr>
                                        <tr>
                                          <td>219-2-3</td>
                                        </tr>
                                      </tbody>
                                    </table>
                                  </div>
                                </td>
                              </tr>
                              <tr>
                                <td>219-3</td>
                              </tr>
                            </tbody>
                          </table>
                        </div>
                      </td>
                    </tr>
                    <tr>
                      <td>657</td>
                    </tr>
                    <tr>
                      <td>175</td>
                    </tr>
                    <tr>
                      <td>134</td>
                    </tr>
                    <tr>
                      <td>494</td>
                    </tr>
                    <tr>
                      <td>832</td>
                    </tr>
                    <tr>
                      <td>982</td>
                    </tr>
                  </tbody>
                </table>
              </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
            </div>
        </section>
    <!-- /.content -->
  </div>
  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->
<!-- jQuery -->
<script src="../../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- DataTables  & Plugins -->
<script src="../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
<script src="../../plugins/jszip/jszip.min.js"></script>
<script src="../../plugins/pdfmake/pdfmake.min.js"></script>
<script src="../../plugins/pdfmake/vfs_fonts.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.html5.min.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.print.min.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.colVis.min.js"></script>
<script src="../../plugins/select2/js/select2.full.min.js"></script>
<!-- AdminLTE App -->
<script src="../../dist/js/adminlte.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="../../dist/js/demo.js"></script>
<script src="../../dist/js/sweetalert.min.js"></script>
<script src="../../dist/js/bootstrap-treeview.js"></script>
<!-- Page specific script -->
<script>

$(function () {
    //Initialize Select2 Elements
    $('.select2').select2()

    //Initialize Select2 Elements
    $('.select2bs4').select2({
      theme: 'bootstrap4'
    });
});

$(document).ready(function(){
  $.ajax({
    url: "../../php/read/permissao.php",
    type: "post",
    dataType: "json",
    success: function(data){
      let select = "";
      for(let i = 0; i < data.length; i++){
        select += `
        <tr data-widget="expandable-table" aria-expanded="true">
          <td><i class="expandable-table-caret fas fa-caret-right fa-fw" style="margin-right: 25px;"></i><input class="custom-control-input custom-control-input-primary custom-control-input-outline" type="checkbox" id="customCheckbox5" checked><label for="customCheckbox5" class="custom-control-label" style="font-weight: 500;">${data[i]["nome"]}</label></td>
        </tr>
      `;

      }

      
      /*if(data != 0){
        for(var key in data){
            console.log("Dados: ", data[key]);
            if(data[key]['node'] != 0){
              select += `
                <tr data-widget="expandable-table" aria-expanded="false">
                  <td style="padding-left: 3rem;"><i class="expandable-table-caret fas fa-caret-right fa-fw" style="margin-right: 25px;"></i><input class="custom-control-input custom-control-input-primary custom-control-input-outline" type="checkbox" id="customCheckbox5" checked><label for="customCheckbox5" class="custom-control-label" style="font-weight: 500;">${data[key]['nome']}</label></td>
                </tr>
              `;
              node(data);
            } else {
              select += `
                <tr data-widget="expandable-table" aria-expanded="false">
                  <td style="padding-left: 3rem;"><input class="custom-control-input custom-control-input-primary custom-control-input-outline" type="checkbox" id="customCheckbox5" checked><label for="customCheckbox5" class="custom-control-label" style="font-weight: 500;">${data[key]['nome']}</label></td>
                </tr>
              `;
            }
            select += `
              <tr>
                <td style="padding-left: 3rem;"><input class="custom-control-input custom-control-input-primary custom-control-input-outline" type="checkbox" id="customCheckbox5" checked><label for="customCheckbox5" class="custom-control-label" style="font-weight: 500;">${data[key]['nome']}</label></td>
              </tr>
            `;
        }
          }
        for(var key in data){
          if(data[key] != 0){
            select += `
            <tr>
              <td style="padding-left: 3rem;"><input class="custom-control-input custom-control-input-primary custom-control-input-outline" type="checkbox" id="customCheckbox5" checked><label for="customCheckbox5" class="custom-control-label" style="font-weight: 500;">${data[key]['nome']}</label></td>
            </tr>
          `;
          node(data);
          }
        }
        
        function node(data){
          for(var key in data){
            let no = data[key]['node'];
            for(var key in no){
              node(no[key]['node']);
              if(no[key]['node'] != 0){
                console.log("Está aqui: ", no[key]['node']);
                select += `
            <tr data-widget="expandable-table" aria-expanded="false">
              <td style="padding-left: 3rem;"><i class="expandable-table-caret fas fa-caret-right fa-fw" style="margin-right: 25px;"></i><input class="custom-control-input custom-control-input-primary custom-control-input-outline" type="checkbox" id="customCheckbox5" checked><label for="customCheckbox5" class="custom-control-label" style="font-weight: 500;">${no[key]['nome']}</label></td>
            </tr>
          `;
              } else {
                select += `
            <tr data-widget="expandable-table" aria-expanded="false">
              <td style="padding-left: 3rem;"><input class="custom-control-input custom-control-input-primary custom-control-input-outline" type="checkbox" id="customCheckbox5" checked><label for="customCheckbox5" class="custom-control-label" style="font-weight: 500;">${no[key]['nome']}</label></td>
            </tr>
          `;
              }
            }
          }
        }*/
      
      //$("#treeView").html(select);
      $("#treeview").treeview({data: data});
    }
  });
});

$(document).on("change", "#periodo", function(e){
  e.preventDefault();
  var periodo = $(this).val();
  $.ajax({
    url: "../../php/select/queryCurso.php",
    type: "post",
    dataType: "json",
    data: {
      periodo: periodo
    },
    success: function(data){
      let select = "";
      select += "<option value='0'>Selecione curso</option>";
      for(var key in data){
        select += "<option value="+data[key]['idCurso']+">"+data[key]['nome']+"</option>";
      }
      console.log(select);
      $("#curso").html(select);
    }
  });
});

$(document).on("change", "#curso", function(e){
  e.preventDefault();
  var curso = $(this).val();
  $.ajax({
    url: "../../php/select/queryTurma.php",
    type: "post",
    dataType: "json",
    data: {
      curso: curso
    },
    success: function(data){
      let select = "";
      select += "<option value='0'>Selecione turma</option>";
      for(var key in data){
        select += "<option value="+data[key]['idTurma']+">"+data[key]['nome']+"</option>";
      }
      console.log(select);
      $("#turma").html(select);
    }
  });
});

$(document).on("change", "#turma", function(e){
  e.preventDefault();
  var turma = $(this).val();
  $.ajax({
    url: "../../php/select/queryAluno.php",
    type: "post",
    dataType: "json",
    data: {
      turma: turma
    }
    }).done(function(data){
      console.log("Está aqui a lista de alunos filtrada: ", data);
      $("#tabelaAluno").DataTable().clear().draw();
      $("#tabelaAluno").DataTable().rows.add(data);
      $("#tabelaAluno").DataTable().columns.adjust().draw();
    });
});

$(document).ready(function(){
    $.ajax({
        url: "../../php/read/aluno.php",
        type: "post",
        dataType: "json"
    }).done(function(data){
        $("#tabelaAluno").DataTable({
        "aaData": data,
        "columns": [{data: "idUsuario"}, {data: "nome"}, {data: "bi"}, {data: "telefone"}, {data: "endereco"}, {data: "nomeUsuario"}, {data: "tipoUsuario"}, {data: "estado"}],
        "responsive": true, "lengthChange": false, "autoWidth": false, "language": idiomaPortugues, 
        lengthMenu: [[7, 25, 50, -1], [10, 25, 50, 'All']], 
        "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#tabelaAluno_wrapper .col-md-6:eq(0)');
    });
});

var idiomaPortugues = {
  buttons: {
      copy: "Copiar",
      print: "Imprimir",
      colvis: "Visibilidade"
  },
  "sProcessing": "A processar...",
  "sLengthMenu": "Mostrar _MENU_ dos registros",
  "sZeroRecords": "Sem resultados!",
  "sEmptyTable": "Tabela sem dados disponíveis",
  "sInfo": "De _START_ à _END_ de um total de _TOTAL_ registros",
  "sInfoEmpty": "De 0 à 0 de um total de 0 registros",
  "sInfoFiltered": "(filtrado de um total de _MAX_ registros)",
  "sInfoPostFix": "",
  "sSearch": "Pesquisar:",
  "sUrl": "",
  "sInfoThousands": ",",
  "sLoadingRecords": "A carregar...",
  "oPaginate": {
      "sFirst": "Primeira",
      "sLast": "Última",
      "sNext": "Seguinte",
      "sPrevious": "Anterior"
  },
  "oAria": {
      "sSortAscending": ": Activar para ordenar a coluna de forma ascendente",
      "sSortDescending": ": Activar para ordenar a coluna de forma descendente"
  }
}

$(document).on("click", "#btn-delete", function(e){
  e.preventDefault();
  console.log(idAluno);
  swal({
    title: "Tem a certeza que pretende eliminar aluno?",
    text: "Aluno: "+ nome.value,
    icon: "warning",
    buttons: true,
    dangerMode: true,
  })
  .then((willDelete) => {
    if (willDelete) {
      $.ajax({
        url: "../../php/delete/usuario.php",
        type: "post",
        dataType: "json",
        data: {
          idAluno: idAluno
      },
      success:function(data){
        console.log(data);
        updateTable();
        swal("Aluno "+ nome.value +" eliminado com sucesso!", {
        icon: "success",
      });
      }
      });
    }
  });
});

$('#tabelaAluno tbody').on('click', 'td', function () {
    let tabela = document.getElementById("tabelaAluno");
    
    for(i = 1; i < tabela.rows.length; i++){
      tabela.rows[i].ondblclick = function(){
          idAluno = this.cells[0].innerHTML;
          console.log(idAluno);
          ajax();
          //$('#modal-lg').modal('show');
          //this.classList.remove("selected");
      }
    }

    function ajax(){
      $.ajax({
        url: "../../php/read/queryAluno.php",
        type: "post",
        dataType: "json",
        data: {
          idAluno: idAluno
        },
        success: function(data){
          imagemInfo = document.getElementById("imagemInfo");
          nomeInfo = document.getElementById("nomeInfo");
          classeInfo = document.getElementById("classeInfo");
          turnoInfo = document.getElementById("turnoInfo");
          generoInfo = document.getElementById("generoInfo");
          emailInfo = document.getElementById("emailInfo");
          telefoneInfo = document.getElementById("telefoneInfo");
          enderecoInfo = document.getElementById("enderecoInfo");
          nomeUsuarioInfo = document.getElementById("nomeUsuarioInfo");
          dataNascInfo = document.getElementById("dataNascInfo");
          dataAdmissaoInfo = document.getElementById("dataAdmissaoInfo");
          biInfo = document.getElementById("biInfo");
          nomeModal = document.getElementById("nomeModal");

          nomeUpdate = document.getElementById("nome");
          emailUpdate = document.getElementById("email");
          dataNascUpdate = document.getElementById("dataNasc");
          telefoneUpdate = document.getElementById("telefone");
          enderecoUpdate = document.getElementById("endereco");
          biUpdate = document.getElementById("bi");
          generoUpdate = document.getElementById("genero");
          imgUpdate = document.querySelector(".image-container");
          
          for(var key in data){
            if(data[key]['imagem'] == null){
              imagemInfo.style.backgroundImage = "url('../../images/default.png')";
            } else {
              imagemInfo.style.backgroundImage = "url('../../images/fotoPerfil/" + data[key]['imagem'] + "')";
            }
            
            nomeModal.innerText = data[key]['nome'];
            nomeInfo.innerText = data[key]['nome'];
            periodoInfo.innerText = data[key]['periodo'];
            cursoInfo.innerText = data[key]['curso'];
            turmaInfo.innerText = data[key]['turma'];
            generoInfo.innerText = data[key]['genero'];
            emailInfo.innerText = data[key]['email'];
            telefoneInfo.innerText = data[key]['telefone'];
            enderecoInfo.innerText = data[key]['endereco'];
            nomeUsuarioInfo.innerText = data[key]['nomeUsuario'];
            dataNascInfo.innerText = data[key]['dataNasc'];
            dataAdmissaoInfo.innerText = data[key]['dataAdesao'];
            biInfo.innerText = data[key]['bi'];

            imgUpdate.style.backgroundImage = "url('../../images/fotoPerfil/" + data[key]['imagem'] + "')";
            imgUpdate.querySelector("i").style.display = "none";

            $('#genero').val(data[key]['genero']);
            $('#genero').select2().trigger('change');

            nomeUpdate.value = data[key]['nome'];
            emailUpdate.value = data[key]['email'];
            dataNascUpdate.value = data[key]['dataNasc'];
            telefoneUpdate.value = data[key]['telefone'];
            enderecoUpdate.value = data[key]['endereco'];
            biUpdate.value = data[key]['bi'];
          }
        }
      }).done(function(data){
        $('#modal-updateAluno').modal('show');
      });
    }
});

$(document).on("click", "#btn-submit", function(e){
  e.preventDefault();
  let form_data = new FormData();
  let img = $("#file")[0].files;
  console.log("Esse é o id do mambo: ", idAluno);
  let nome = document.getElementById("nome");
  let email = document.getElementById("email");
  let dataNasc = document.getElementById("dataNasc");
  let telefone = document.getElementById("telefone");
  let endereco = document.getElementById("endereco");
  let bi = document.getElementById("bi");
  let genero = document.getElementById("genero");
  let tipoUsuario = document.getElementById("tipoUsuario");
  console.log("Esse é o nome: ", nome);

  form_data.append('idUsuario', idAluno);
  form_data.append('imagem', img[0]);
  form_data.append('nome', nome.value);
  form_data.append('email', email.value);
  form_data.append('dataNasc', dataNasc.value);
  form_data.append('telefone', telefone.value);
  form_data.append('endereco', endereco.value);
  form_data.append('bi', bi.value);
  form_data.append('genero', genero.value);
  form_data.append('tipoUsuario', tipoUsuario.value);
  
  swal({
    title: "Tem a certeza que pretende editar dados?",
    text: "Aluno: "+ nome.value,
    icon: "warning",
    buttons: true,
  })
  .then((willUpdate) => {
  if (willUpdate) {
  $.ajax({
      url: "../../php/update/usuario.php",
      type: "post",
      data: form_data,
      cache: false,
      contentType: false,
      processData: false,
      success: function(data){
        console.log(data);
        updateTable();
        swal({
          title: "Edição efectuada com sucesso!",
          text: "Aluno "+ nome.value +" actualizado!",
          icon: "success",
        });
      }
    });
  }
});
});

function updateTable(){

  $.ajax({
        url: "../../php/read/aluno.php",
        type: "post",
        dataType: "json"
    }).done(function(data){
      console.log("Está aqui a lista de alunos filtrada: ", data);
      $("#tabelaAluno").DataTable().clear().draw();
      $("#tabelaAluno").DataTable().rows.add(data);
      $("#tabelaAluno").DataTable().columns.adjust().draw();
    });
}
</script>
</body>
</html>
