<!DOCTYPE html>
<html lang="pt-pt">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Listagem histórico de pagamento</title>
  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../../plugins/fontawesome-free/css/all.min.css">
  <!-- Select2 -->
  <link rel="stylesheet" href="../../plugins/select2/css/select2.min.css">
  <link rel="stylesheet" href="../../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../../plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="../../plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="../../plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../../dist/css/adminlte.min.css">
  <link rel="stylesheet" href="../../style.css">
</head>
<body class="sidebar-mini iframe-mode">
<div class="wrapper">
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header" style="padding: 10px .5rem;">
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
            <div class="row">
                <div class="col-12">

                <div class="card">
                    <div class="card-header">
                      <div class="col-sm-6">
                        <div class="form-group margem">
                          <p class="card-title breadcrumb-item active" style="padding: .375rem;">Listagem - Histórico de pagamento</p>
                        </div>
                      </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                    <table id="tabelaHistorico" class="table table-bordered table-striped" style="line-height: 0.8;">
                    <thead>
                        <tr>
                            <th title="Número de estudante">Número</th>
                            <th>Nome completo</th>
                            <th>E-mail</th>
                            <th title="Bilhete de identidade">B.I</th>
                            <th>Telefone</th>
                            <th>Endereço</th>
                            <th>Classe</th>
                            <th>Turno</th>
                        </tr>
                    </thead>
                    <tbody id="corpoTabela">
                        
                    </tbody>
                    </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
            </div>
        </section>
        <div class="modal fade" id="modal-lg">
        <div class="modal-dialog modal-lg">
          <div class="modal-content">
            <div class="modal-header" style="padding: 0.5rem;">
                <h3 class="card-title p-3">Estudante - <span id="nomeModal"></span></h3>
                <ul class="nav nav-pills ml-auto p-2">
                  <li class="nav-item"><a class="nav-link active" href="#tab_info" data-toggle="tab">Informações</a></li>
                  <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" data-toggle="dropdown" href="#">
                      Acções <span class="caret"></span>
                    </a>
                    <div class="dropdown-menu">
                      <a class="dropdown-item" tabindex="-1" href="#tab_editar" data-toggle="tab">Editar</a>
                      <div class="dropdown-divider"></div>
                      <a class="dropdown-item" tabindex="-1" href="#">Eliminar</a>
                    </div>
                  </li>
                </ul>
            </div>
            <div class="modal-body" style="padding-bottom: 0px;">
            <div class="tab-content">
              <div class="tab-pane active" id="tab_info">
                <div class="row">
                  <div class="col-md-12">
                    <form name="tabelaHistorico">
                      <table name="tabelaHistorico" class="table table-sm table-bordered" style="min-width: 100%;
                      max-width: 100%;">
                        <tr name="linhaItem">
                          <td style="width: 400px;">
                            <div class="form-group margem">
                              <div class="caixa" id="imagemInfo" style="background-image: url(dist/img/photo1.png);">
                              </div>
                            </div>
                          </td>
                          <td style="padding: 50px 0px 0px 10px;">
                            <p>Nome do estudante: <span id="nomeInfo"></span></p>
                            <p>Classe: <span id="classeInfo"></span>, &nbsp; Turno: <span id="turnoInfo"></span></p>
                            <p>Bilhete de identidade: <span id="biInfo"></span>, &nbsp; Género: <span id="generoInfo"></span></p>
                            <p>E-mail: <span id="emailInfo"></span></p>
                            <p>Nome usuário: <span id="nomeUsuarioInfo"></span></p>
                            <p>Endereço: <span id="enderecoInfo"></span>, &nbsp; Telefone: <span id="telefoneInfo"></span></p>
                            <p>Data de nascimento: <span id="dataNascInfo"></span></p>
                            <p>Data de adimissão: <span id="dataAdmissaoInfo"></span></p>
                          </td>
                        </tr>
                      </table>
                    </form>
                  </div>
                </div>
              </div>
              <!-- /.tab-pane -->
              <div class="tab-pane" id="tab_editar">
                <div class="row">
                  <div class="col-md-2" style="text-align: -webkit-center;">
                    <div class="form-group margem">
                      <div class="wrapper-image">
                        <div class="image-container">
                          <i class="fa fa-user"></i>
                          <img id="foto" src="" alt="">
                        </div>
                        <label for="file" class="camera-icon">
                        <i class="fas fa-camera"></i>
                        </label>
                        <input type="file" id="file" name="file" accept="image/*" hidden>
                      </div>
                    </div>
                  </div>
                <div class="col-md-3">
                  <div class="form-group margem">
                    <input type="text" class="form-control" id="nomeCompleto" name="nomeCompleto" placeholder="*Nome completo" title="Nome completo">
                    <small>Mensagem de erro</small>
                  </div>
                  <div class="form-group margem">
                    <select class="form-control select2" style="width: 100%;" id="encarregado" name="encarregado" title="Encarregado de educação">
                    </select>
                    <small>Mensagem de erro</small>
                  </div>
                  <div class="form-group margem">
                    <select class="form-control select2" style="width: 100%;" id="genero" name="genero" title="Género (Masculino, Feminino)">
                    <option selected="selected" value="Masculino">Masculino</option>
                    <option value="Feminino">Feminino</option>
                    </select>
                    <small>Mensagem de erro</small>
                  </div>
                  <div class="form-group margem">
                    <select class="form-control select2" style="width: 100%;" id="classe" name="classe" title="Classe">
                    </select>
                    <small>Mensagem de erro</small>
                  </div>
                  <div class="form-group margem">
                    <select class="form-control select2" style="width: 100%;" id="turno1" name="turno1" title="Turno1">
                    <option value="0">Selecione turno</option>
                    <option value="1">Manhã</option>
                    <option value="2">Tarde</option>
                    </select>
                    <small>Mensagem de erro</small>
                  </div>
                </div>
                <!-- /.col -->
                <div class="col-md-3">
                  <div class="form-group margem">
                    <input type="date" class="form-control" id="dataAdmissao" name="dataAdmissao" placeholder="Data de adimissão" title="Data de adimissão">
                    <small>Mensagem de erro</small>
                  </div>
                  <div class="form-group margem">
                    <input type="date" class="form-control" id="dataNasc" name="dataNasc" placeholder="Data de nascimento" title="Data de nascimento">
                    <small>Mensagem de erro</small>
                  </div>
                  <div class="form-group margem">
                    <input type="text" class="form-control" id="telefone" name="telefone" placeholder="Telefone" title="Número de telefone">
                    <small>Mensagem de erro</small>
                  </div>
                  <div class="form-group margem">
                    <input type="text" class="form-control" id="endereco" name="endereco" placeholder="Endereço" title="Endereço">
                    <small>Mensagem de erro</small>
                  </div>
                  <div class="form-group margem">
                    <input type="text" class="form-control" id="bi" name="bi" placeholder="Bilhete de identidade" title="Bilhete de identidade">
                    <small>Mensagem de erro</small>
                  </div>
                </div>
                <!-- /.col -->
                <div class="col-md-3">
                  <div class="form-group margem">
                    <input type="email" class="form-control" id="email" name="email" placeholder="E-mail" title="E-mail">
                    <small>Mensagem de erro</small>
                  </div>
                  <div class="form-group margem">
                    <input type="text" class="form-control" id="nomeUsuario" name="nomeUsuario" placeholder="*Nome usuário" title="Nome de usuário">
                    <small>Mensagem de erro</small>
                  </div>
                  <div class="form-group">
                    <button type="submit" name="btn-submit" id="btn-submit" class="btn btn-block btn-outline-primary" disabled>Editar dados</button>
                  </div>
                  </div>
                </div>
              </div>
            </div>
        </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
      </div>
    <!-- /.content -->
  </div>
  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->
<!-- jQuery -->
<script src="../../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- DataTables  & Plugins -->
<script src="../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
<script src="../../plugins/jszip/jszip.min.js"></script>
<script src="../../plugins/pdfmake/pdfmake.min.js"></script>
<script src="../../plugins/pdfmake/vfs_fonts.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.html5.min.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.print.min.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.colVis.min.js"></script>
<script src="../../plugins/select2/js/select2.full.min.js"></script>
<!-- AdminLTE App -->
<script src="../../dist/js/adminlte.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="../../dist/js/demo.js"></script>
<!-- Page specific script -->
<script>

$(function () {
    //Initialize Select2 Elements
    $('.select2').select2()

    //Initialize Select2 Elements
    $('.select2bs4').select2({
      theme: 'bootstrap4'
    });
});

$(document).ready(function(){
    $.ajax({
        url: "../../php/selectAluno.php",
        type: "post",
        dataType: "json"
    }).done(function(data){
        console.log(data);
    });
});

$(document).ready(function(){
    $.ajax({
        url: "../../php/listagemAluno.php",
        type: "post",
        dataType: "json"
    }).done(function(data){
        $("#tabelaHistorico").DataTable({
        "aaData": data,
        "columns": [{data: "idEstudante"}, {data: "nomeCompleto"}, {data: "email"}, {data: "bi"}, {data: "telefone"}, {data: "endereco"}, {data: "idClasse"}, {data: "idTurno"}],
        "responsive": true, "lengthChange": false, "autoWidth": false, "language": idiomaPortugues, 
        lengthMenu: [[7, 25, 50, -1], [10, 25, 50, 'All']], 
        "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#tabelaHistorico_wrapper .col-md-6:eq(0)');
    });
});

var idiomaPortugues = {
  buttons: {
      copy: "Copiar",
      print: "Imprimir",
      colvis: "Visibilidade"
  },
  "sProcessing": "A processar...",
  "sLengthMenu": "Mostrar _MENU_ dos registros",
  "sZeroRecords": "Sem resultados!",
  "sEmptyTable": "Tabela sem dados disponíveis",
  "sInfo": "De _START_ à _END_ de um total de _TOTAL_ registros",
  "sInfoEmpty": "De 0 à 0 de um total de 0 registros",
  "sInfoFiltered": "(filtrado de um total de _MAX_ registros)",
  "sInfoPostFix": "",
  "sSearch": "Pesquisar:",
  "sUrl": "",
  "sInfoThousands": ",",
  "sLoadingRecords": "A carregar...",
  "oPaginate": {
      "sFirst": "Primeira",
      "sLast": "Última",
      "sNext": "Seguinte",
      "sPrevious": "Anterior"
  },
  "oAria": {
      "sSortAscending": ": Activar para ordenar a coluna de forma ascendente",
      "sSortDescending": ": Activar para ordenar a coluna de forma descendente"
  }
}
</script>
</body>
</html>
