<?php
    class TipoArtigoModel extends Database {

		protected function insertTipoArtigo($nome, $nota){
            $stmt = $this->connect();
            $sql = "INSERT INTO tipoArtigo (nome, nota) VALUES (?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($nome, $nota)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemTipoArtigo(){
			$data = null;
			$sql = "SELECT * FROM tipoArtigo";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function editTipoArtigo($idTipoArtigo, $nome, $nota){
			$stmt = $this->connect();
			
            $sql = "UPDATE tipoArtigo SET nome = ?, nota = ? WHERE idTipoArtigo = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($nome, $nota, $idTipoArtigo)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function queryTipoArtigo($idTipoArtigo){
			$data = null;
			$sql = "SELECT * FROM tipoArtigo WHERE idTipoArtigo = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTipoArtigo]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function deleteTipoArtigo($idTipoArtigo){
			$stmt = $this->connect();
            $sql = "DELETE FROM tipoartigo WHERE idTipoArtigo = ?";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idTipoArtigo)))){
				$query = null;
				exit();
			}
		}

    }