<?php

	class LoginModel extends Database {

		protected function readUsuario($nomeUsuarioEmail){
			$data = null;
			$sql = "SELECT * FROM usuario WHERE nomeUsuario = ? OR email = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$nomeUsuarioEmail, $nomeUsuarioEmail]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function loginUsuario($nomeUsuarioEmail, $senha){
			$usuario = $this->readUsuario($nomeUsuarioEmail);
			if($usuario == false){
				header("location: ../index.php?Erro=CredenciaisInvalidas!");
				exit();
			}
			$id = $usuario[0]["idUsuario"];
			//$img = $this->profileImg($id);
			/*if($img == false){
				echo "Não tem imagem esse user!: " . $usuario[0]["nome"];
				exit();
			} else {
				echo "Tem imagem esse user!: " . $usuario[0]["nome"];
				exit();
			}*/
			$pwdHashed = $usuario[0]["senha"];
			$checkPwd = password_verify($senha, $pwdHashed);
			if($checkPwd == false){
				header("location: ../index.php?Erro=CredenciaisInvalidas!");
				exit();
			} else if($checkPwd == true){
				session_start();
				$_SESSION["usuarioId"] = $usuario[0]["idUsuario"];
				$_SESSION["usuarioNome"] = $usuario[0]["nome"];
				$_SESSION["usuarioImagem"] = $usuario[0]["imagem"];
			}
			$data = $this->getUserData($_SESSION["usuarioId"]);
			$_SESSION["usuarioTipoUsuario"] = $data[0]["tipoUsuario"];
		}

		protected function getUserData($id){
			$data = null;
			$sql = "SELECT * FROM viewusuariotipo WHERE idUsuario = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$id]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function profileImg($id){
			$data = null;
			$sql = "SELECT * FROM profileimg WHERE idUsuario = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$id]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function getUser($nomeUsuarioEmail, $senha){
			$sql = "SELECT * FROM usuario WHERE nomeUsuario = ? OR email = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute(array($nomeUsuarioEmail, $nomeUsuarioEmail))){
				$stmt = null;
				header("location: ../index.php?Erro=stmtFalhou!");
				exit();
			}
			if($stmt->rowCount() == 0){
				$stmt = null;
				header("location: ../index.php?Erro=UsuarioInexistente!");
				exit();
			}

			$senhaHashed = $stmt->fetchAll(PDO::FETCH_ASSOC);
			$checkSenha = password_verify($senha, $senhaHashed[0]["senha"]);

			if($checkSenha == false){
				$stmt = null;
				header("location: ../index.php?Erro=SenhaIncorrecta!");
				exit();
			} else if($checkSenha == true){
				$sql = "SELECT * FROM usuario WHERE nomeUsuario = ? OR email = ? AND senha = ?;";
				$stmt = $this->connect()->prepare($sql);
				if(!$stmt->execute(array($nomeUsuarioEmail, $nomeUsuarioEmail, $senha))){
					$stmt = null;
					header("location: ../index.php?Erro=stmtFalhou!");
					exit();
				}
				if($stmt->rowCount() == 0){
					$stmt = null;
					header("location: ../index.php?Erro=UsuarioNaoEncontrado!");
					exit();
				}
				$user = $stmt->fetchAll(PDO::FETCH_ASSOC);
				session_start();
				$_SESSION["usuarioId"] = $user[0]["idUsuario"];
				$_SESSION["usuarioNome"] = $user[0]["nome"];
				$_SESSION["usuarioTipoUsuario"] = $user[0]["tipoUsuario"];
				$_SESSION["usuarioFoto"] = $user[0]["imagem"];
				$stmt = null;
			}

		}
	}