<?php
    class AlunoModel extends Database {

		protected function insertUsuarioDois($nome, $email, $dataNasc, $telefone, $endereco, $bi, $genero, $tipoUsuario, $periodo, $curso, $ficheiro, $nomeFicheiro, $tipoFicheiro, $nomeTemporarioFicheiro, $erroFicheiro, $tamanhoFicheiro, $extensaoFicheiro, $extensaoActualFicheiro, $permitido, $nomeCompletoImagem, $destinoFicheiro){
			$stmt = $this->connect();
			
            $sql = "INSERT INTO usuario (nome, email, dataNasc, telefone, endereco, bi, genero, idTipoUsuario, imagem) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($nome, $email, $dataNasc, $telefone, $endereco, $bi, $genero, $tipoUsuario, $nomeCompletoImagem)))){
				$query = null;
				exit();
			}
            move_uploaded_file($nomeTemporarioFicheiro, $destinoFicheiro);
			$id = $stmt->lastInsertId();
			$this->insertPeriodoCurso($id, $periodo, $curso);
			$idTurma = $this->getTurma($periodo, $curso);
			$this->insertTurmaAluno($idTurma[0]["idTurma"], $id);
			$this->editTurma($idTurma[0]["idTurma"], $idTurma[0]["capacidade"]);
			$capacidade = $this->verifyTurma($idTurma[0]["idTurma"]);
			$idTurma2 = $this->getTurma($periodo, $curso);
			if($idTurma2 == null){
				$this->editStatusCurso($curso);
			}
			return $id;
        }

		public function insertAluno($nome, $email, $dataNasc, $telefone, $endereco, $bi, $genero, $tipoUsuario, $periodo, $curso){
			$stmt = $this->connect();
			
            $sql = "INSERT INTO usuario (nome, email, dataNasc, telefone, endereco, bi, genero, idTipoUsuario) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($nome, $email, $dataNasc, $telefone, $endereco, $bi, $genero, $tipoUsuario)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			$this->insertPeriodoCurso($id, $periodo, $curso);
			$idTurma = $this->getTurma($periodo, $curso);
			$this->insertTurmaAluno($idTurma[0]["idTurma"], $id);
			$this->editTurma($idTurma[0]["idTurma"], $idTurma[0]["capacidade"]);
			$capacidade = $this->verifyTurma($idTurma[0]["idTurma"]);
			$idTurma2 = $this->getTurma($periodo, $curso);
			if($idTurma2 == null){
				$this->editStatusCurso($curso);
			}
			return $id;
        }

		public function codigoAlunoTurma($idAluno){
			$data = null;
			$sql = "SELECT * FROM viewcodigoalunoturma WHERE usuario = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idAluno]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function listagemAluno(){
			$data = null;
			$sql = "SELECT * FROM viewusuariotipoidentificador WHERE idTipoUsuario = 2";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function verifyTurma($idTurma){
			$data = null;
			$sql = "SELECT * FROM turma WHERE idTurma = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTurma]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		protected function editStatusCurso($idCurso){
			$estado = "Inactivo";
			$stmt = $this->connect();
			
            $sql = "UPDATE curso SET estado = ? WHERE idCurso = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($estado, $idCurso)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		protected function editStatusCurso2($idCurso){
			$estado = "Activo";
			$stmt = $this->connect();
			
            $sql = "UPDATE curso SET estado = ? WHERE idCurso = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($estado, $idCurso)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }
		
		protected function editTurma($idTurma, $capacidade){
			$decremento = $capacidade - 1;
			$stmt = $this->connect();
			
            $sql = "UPDATE turma SET capacidade = ? WHERE idTurma = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($decremento, $idTurma)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		protected function getTurma($periodo, $curso){
			$stmt = $this->connect();
            $sql = "SELECT * FROM turma WHERE idPeriodo = ? AND idCurso = ? AND NOT capacidade = 0 LIMIT 1";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$periodo, $curso]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function insertPeriodoCurso($idUsuario, $periodo, $curso){
			$stmt = $this->connect();
			$sql = "INSERT INTO periodoCursoAluno (aluno, periodo, curso) VALUES (?, ?, ?)";
			$query = $stmt->prepare($sql);
			$query->execute(array($idUsuario, $periodo, $curso));
        }

		protected function insertTurmaAluno($idTurma, $idAluno){
			$stmt = $this->connect();
			
            $sql = "INSERT INTO turmaaluno (turma, aluno) VALUES (?, ?)";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($idTurma, $idAluno)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function readTurma(){
			$data = null;
			$sql = "SELECT * FROM turma";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function readTipoUsuario($idUsuario){
			$data = null;
			$sql = "SELECT * FROM usuario WHERE idUsuario = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idUsuario]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function fotoPerfil($idUsuario){
			$data = null;
			$sql = "SELECT * FROM usuario WHERE idUsuario = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idUsuario]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function eraseUsuario($idUsuario){
			$stmt = $this->connect();
            $sql = "DELETE FROM usuario WHERE idUsuario = ?";
            $query = $stmt->prepare($sql);
			$img = $this->fotoPerfil($idUsuario);
			$nameImg = "../../images/fotoPerfil/" . $img[0]["imagem"];
			$fileInfo = glob($nameImg);
			$fileExt = explode(".", $fileInfo[0]);
			$fileActualExt = $fileExt[5];
        	$file = $nameImg;
			unlink($file);
            if(!($query->execute(array($idUsuario)))){
				$query = null;
				exit();
			}
		}

		protected function editAluno($idAluno, $nome, $email, $dataNasc, $telefone, $endereco, $bi, $genero, $tipoUsuario, $periodo, $curso){
			$stmt = $this->connect();
			
            $sql = "UPDATE usuario SET nome = ?, email = ?, dataNasc = ?, telefone = ?, endereco = ?, bi = ?, genero = ?, idTipoUsuario = ? WHERE idUsuario = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($nome, $email, $dataNasc, $telefone, $endereco, $bi, $genero, $tipoUsuario, $idAluno)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();

			$this->updatePeriodoCurso($idAluno, $periodo, $curso);
			$turmaAluno = $this->getTurmaAluno($idAluno);
			$turma = $this->getTurma2($turmaAluno[0]['turma']);
			$this->editTurma2($turma[0]["idTurma"], $turma[0]["capacidade"]);
			$idTurma = $this->getTurma($periodo, $curso);
			$this->editTurma($idTurma[0]["idTurma"], $idTurma[0]["capacidade"]);
			$this->updateTurmaAluno($idTurma[0]["idTurma"], $idAluno);
			$idTurma2 = $this->getTurma($periodo, $curso);
			if($idTurma2 == null){
				$this->editStatusCurso($curso);
			}
			if($turma !== null){
				$yh = "Tem alguma coisa!";
				//$this->editStatusCurso2($curso);
			} else {
				$yh = "Não tem nada!";
			}

			return $id;
        }

		protected function updatePeriodoCurso($idAluno, $periodo, $curso){
			$stmt = $this->connect();
			$sql = "UPDATE periodoCursoAluno SET periodo = ?, curso = ? WHERE aluno = ?";
			$query = $stmt->prepare($sql);
			$query->execute(array($periodo, $curso, $idAluno));
        }

		protected function getTurmaAluno($idAluno){
			$stmt = $this->connect();
            $sql = "SELECT * from turmaaluno WHERE aluno = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idAluno]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function getTurma2($idTurma){
			$stmt = $this->connect();
            $sql = "SELECT * FROM turma WHERE idTurma = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTurma]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}
		
		protected function updateTurmaAluno($idTurma, $idAluno){
			$stmt = $this->connect();
            $sql = "UPDATE turmaaluno SET turma = ? WHERE aluno = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTurma, $idAluno]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function deleteAlunoTurma($idAluno){
			$stmt = $this->connect();
            $sql = "DELETE FROM turmaaluno WHERE aluno = ?";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idAluno)))){
				$query = null;
				exit();
			}
		}

		protected function editTurma2($idTurma, $capacidade){
			$incremento = $capacidade + 1;
			$stmt = $this->connect();
			
            $sql = "UPDATE turma SET capacidade = ? WHERE idTurma = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($incremento, $idTurma)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemProfessor(){
			$data = null;
			$sql = "SELECT * FROM viewusuariotipo WHERE idTipoUsuario = 3";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function listagemUsuario(){
			$data = null;
			$sql = "SELECT * FROM viewusuariotipo WHERE NOT idTipoUsuario BETWEEN 2 AND 3";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

        public function queryEmail($email){
			$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM usuario WHERE email = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$email]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM usuario WHERE email = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$email]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryBi($bi){
			$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM usuario WHERE bi = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$bi]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryNomeUsuario($nomeUsuario){
			$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM usuario WHERE nomeUsuario = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$nomeUsuario]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function listaUsuario(){
			$data = null;
			$sql = "SELECT * FROM usuario";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryAluno($turma){
			$data = null;
			if($turma == 0){
				$sql = "SELECT * FROM turmaaluno ta INNER JOIN viewusuariotipoidentificador u ON (ta.aluno=u.idUsuario)";
				if($stmt = $this->connect()->query($sql)){
					while($row = $stmt->fetch()){
					$data[] = $row;
					}
				}
			} else {
				$sql = "SELECT * FROM turmaaluno ta INNER JOIN viewusuariotipoidentificador u ON (ta.aluno=u.idUsuario) WHERE ta.turma = ?";
				if($stmt = $this->connect()->prepare($sql)){
					$stmt->execute([$turma]);
					while($row = $stmt->fetch()){
					$data[] = $row;
					}
				}
			}
			return $data;
		}

		public function dataAluno($idAluno){
			$data = null;
			$sql = "SELECT * FROM viewdataaluno WHERE idTipoUsuario = 2 AND idUsuario = ? ORDER BY idUsuario ASC";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idAluno]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}
    }